const idArmazem = document.getElementById("idArmazem");
const nome = document.getElementById("nome");
const endereco = document.getElementById("endereco");
const nota = document.getElementById("nota");
const btn = window.parent.document.getElementById("btn-submit");

const slidePage = document.querySelector(".slidePage");
const firstNextBtn = document.querySelector(".nextBtn");
const prevBtnSec = document.querySelector(".prev-1");
const nextBtnSec = document.querySelector(".next-1");
const prevBtnThird = document.querySelector(".prev-2");
const nextBtnThird = document.querySelector(".next-2");
const prevBtnFourth = document.querySelector(".prev-3");
const submitBtn = document.querySelector(".submit");
const progressText = document.querySelectorAll(".step p");
const progressCheck = document.querySelectorAll(".step .check");
const bullet = document.querySelectorAll(".step .bullet");

const footerPagamento = document.getElementById("footerPagamento");

let numberRegExp = new RegExp('^[0-9-()-+ ]+$');
let letterRegExp = new RegExp('^[a-zA-Z ]+$');
let biRegExp = new RegExp('^[a-zA-Z0-9]+$');
let emailRegExp = new RegExp('^[A-Za-z0-9._-]{3,}@[A-Za-z._-]{3,}[.]{1}[A-Za-z.]{2,6}$');

let max = 1;
let current = 1;

function idArmazemInvalid(small){
	idArmazem.classList.add("select2-danger");
	idArmazem.setAttribute('data-dropdown-css-class', 'select2-danger');
	small.style.visibility = "visible";
	small.style.color = "#dc3545";
	small.innerText = "Selecione o armazém!";
	submitBtn.setAttribute('disabled', 'disabled');
}

function idArmazemValid(small){
	idArmazem.classList.remove("select2-danger");
	idArmazem.classList.add("is-valid");
	idArmazem.style.borderColor = "#ffc107";
	submitBtn.removeAttribute('disabled');
	small.style.visibility = "hidden";
}

$('#idArmazem').select2().on('change', function(){
    let small = idArmazem.parentElement.querySelectorAll("small")[1];
    console.log($("#idArmazem").val());
    if($("#idArmazem").val() == 0){
		idArmazemInvalid(small);
    } else {
		idArmazemValid(small);
    }
});

function nomeWarning(small){
	nome.className = "form-control is-warning";
	small.style.visibility = "visible";
	small.style.color = "#ffc107";
	small.innerText = "Campo Descrição é obrigatório!";
	submitBtn.setAttribute('disabled', 'disabled');
}

function nomeValid(small){
	nome.className = "form-control is-valid";
	submitBtn.removeAttribute('disabled');
	small.style.visibility = "hidden";
}

nome.addEventListener("keyup", function(){
	let small = nome.parentElement.querySelectorAll("small")[1];
	if(nome.value === ''){
		nomeWarning(small);
	} else {
		nomeValid(small);
	}
});

function enderecoNormal(small){
	endereco.className = "form-control";
	small.style.visibility = "hidden";
	small.style.color = "#ffc107";
	small.innerText = "Campo Observações é obrigatório!";
	submitBtn.removeAttribute('disabled');
}

function enderecoValid(small){
	endereco.className = "form-control is-valid";
	submitBtn.removeAttribute('disabled');
	small.style.visibility = "hidden";
}

endereco.addEventListener("keyup", function(){
	let small = endereco.parentElement.querySelectorAll("small")[1];
	if(endereco.value === ''){
		enderecoNormal(small);
	} else {
		enderecoValid(small);
	}
});

function notaNormal(small){
	nota.className = "form-control";
	small.style.visibility = "hidden";
	small.style.color = "#ffc107";
	small.innerText = "Campo Observações é obrigatório!";
	submitBtn.removeAttribute('disabled');
}

function notaValid(small){
	nota.className = "form-control is-valid";
	submitBtn.removeAttribute('disabled');
	small.style.visibility = "hidden";
}

nota.addEventListener("keyup", function(){
	let small = nota.parentElement.querySelectorAll("small")[1];
	if(nota.value === ''){
		notaNormal(small);
	} else {
		notaValid(small);
	}
});

submitBtn.addEventListener("click", function(){
	let smallIdArmazem = idArmazem.parentElement.querySelectorAll("small")[1];
	let smallNome = nome.parentElement.querySelectorAll("small")[1];
	let smallNota = nota.parentElement.querySelectorAll("small")[1];
	let smallEndereco = endereco.parentElement.querySelectorAll("small")[1];

	if($("#idArmazem").val() == 0){
        idArmazemInvalid(smallIdArmazem);
    }else {
		idArmazemValid(smallIdArmazem);
	} 

	if(nome.value == ''){
        nomeWarning(smallNome);
    } else {
		nomeValid(smallNome);
	}

	if(endereco.value == ''){
        enderecoNormal(smallEndereco);
    } else {
		enderecoValid(smallEndereco);
	}

	if(nota.value == ''){
        notaNormal(smallNota);
    } else {
		notaValid(smallNota);
	}
});

function resetForm(){
    slidePage.style.marginLeft = "0%";
    current = 1;
}