<!DOCTYPE html>
<html lang="pt">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta http-equiv="Content-Security-Policy" content="script-src 'self' 'unsafe-inline';">
  <link href="./images/logo/<?php echo $rows[9]['valor']; ?>" rel="icon">
  <title>Buesimples | Área do Gestor</title>
  <link rel="stylesheet" href="template/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="template/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="template/plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="template/plugins/fontawesome-free/css/all.min.css">
  <!-- daterange picker -->
  <link rel="stylesheet" href="template/plugins/daterangepicker/daterangepicker.css">
  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="template/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <!-- Bootstrap Color Picker -->
  <link rel="stylesheet" href="template/plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css">
  <!-- Tempusdominus Bootstrap 4 -->
  <link rel="stylesheet" href="template/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css">

  <!-- Select2 -->
  <link rel="stylesheet" href="template/plugins/select2/css/select2.min.css">
  <link rel="stylesheet" href="template/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">
  <!-- Bootstrap4 Duallistbox -->
  <link rel="stylesheet" href="template/plugins/bootstrap4-duallistbox/bootstrap-duallistbox.min.css">
  <!-- BS Stepper -->
  <link rel="stylesheet" href="template/plugins/bs-stepper/css/bs-stepper.min.css">
  <!-- dropzonejs -->
  <link rel="stylesheet" href="template/plugins/dropzone/min/dropzone.min.css">
  <link rel="stylesheet" href="template/plugins/toastr/toastr.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="template/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <style>
    #swal2-title {
      display: flex !important;
      flex-direction: column;
      align-items: center;
    }
  </style>
</head>
<style type="text/css">
  .logo img {
    width: 150px;
  }
</style>

<body class="hold-transition login-page" style="margin: 0; overflow: hidden;">
  <div id="particles-js"></div>
  <div class="login-box" id="caixa-login">
    <div class="card card-body">
      <!-- /.login-logo -->
      <div class="login-logo logo" style="padding-top: 20px;">
        <img style="width: 20%;" src="images/logo/logologin.svg" alt="Imagem Buesimples" class="brand-image">
      </div>
      <div class="card-body login-card-body">
        <form action="includes/login.inc.php" method="post">
          <p class="login-box-msg">Login</p>
          <div class="input-group mb-3 d-none">
            <input type="text" class="form-control" placeholder="Nome de usuário / E-mail" name="" id="">
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
          </div>

          <div class="input-group mb-3">
            <select class="form-control select2" id="nomeUsuarioEmail" name="nomeUsuarioEmail"></select>
            <div class="input-group-append d-none">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
          </div>

          <div class="input-group mb-3">
            <input type="password" class="form-control" placeholder="Palavra-passe" name="senha" id="senha">
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-lock"></span>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-md-12">
              <button type="submit" name="btn-submit" id="btn-submit" class="btn btn-block btn-primary" style="background-color: #560085; border-color: #560085;">Login</button>
            </div>
          </div>
          <p class="mb-1">
            <a href="#" style="color: #666;    display: flex; justify-content: center; color: #666; padding-top: .5rem;">Esqueci-me da palavra-passe!</a>
          </p>
        </form>
      </div>
    </div>
  </div>
  <!-- /.login-box -->
  <!-- jQuery -->
  <script src="template/plugins/jquery/jquery.min.js"></script>
  <!-- Bootstrap 4 -->
  <script src="template/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
  <!-- AdminLTE App -->
  <script src="template/dist/js/adminlte.min.js"></script>
  <script src="template/plugins/toastr/toastr.min.js"></script>
  <script src="./template/dist/js/sweetalert2.min.js"></script>
  <script src="./template/dist/js/particles.min.js"></script>
  <script src="./template/dist/js/app.js"></script>
  <script src="../pos/javascript/function.js"></script>
  <script src="./template/plugins/select2/js/select2.js"></script>
  <script src="../pos/javascript/function.js"></script>
  <script>
    funcaoSelect("../pos/includes/select.inc.php", "post", "json", "usuario", function success(data) {
    }, function error(data) {
      
    }, function done(data) {
      var Users = [];
      data.forEach((item, index) => {
        Users.push(item.nomeUsuario);
      });
      $('.select2').select2({
        placeholder: 'Selecione o seu nome',
        allowClear: true,
        data: Users
      });
    });

    $(function() {
      $('.toastrDefaultSuccess').click(function() {
        toastr.success('Lorem ipsum dolor sit amet, consetetur sadipscing elitr.')
      });
      $('.toastrDefaultInfo').click(function() {
        toastr.info('Lorem ipsum dolor sit amet, consetetur sadipscing elitr.')
      });
      $('.toastrDefaultError').click(function() {
        toastr.error('Lorem ipsum dolor sit amet, consetetur sadipscing elitr.')
      });
      $('.toastrDefaultWarning').click(function() {
        toastr.warning('Lorem ipsum dolor sit amet, consetetur sadipscing elitr.')
      });
    });

    let btn = document.getElementById("btn-submit");
    btn.addEventListener("click", function(e) {
      e.preventDefault();
      
      $(document).ready(function() {
        $.ajax({
          url: "./includes/login/login.inc.php",
          type: "post",
          dataType: "json",
          data: {
            nomeUsuarioEmail: nomeUsuarioEmail.value,
            senha: senha.value
          },
          success: function(data) {
            if (data == "semSenha") {
              //console.log("Sem senha");
              //toastr.info('Coloque o Código que enviamos ao seu E-mail para validar a sua conta.');
              swal.fire({
                title: `<div style="height: 7rem; width: 7rem; display: flex; justify-content: center; align-items: center; border: 1px solid #560085; border-radius: 50%; margin: 1rem;"><i class="fa-solid fa-lock" style="color: #560085d6;"></i></div><h1>Defina a sua senha.</h1>`,
                html: `
              <div style="text-align: left;"><label for="novaSenha">Digite a sua senha</label>
              <input type="password" class="form-control" id="novaSenha" style="margin: .4rem 0rem 0rem 0rem; width: 100%; padding: 1.5rem 1rem; font-size: 2rem; padding: 1.5rem 1rem; font-size: 2rem;">
              <small style="margin-bottom: 1rem; visibility: hidden;">Mensagem de Erro</small></div>
              <div style="text-align: left;"><label for="confirmaNovaSenha">Confirme a sua senha</label>
              <input type="password" class="form-control" id="confirmaNovaSenha" style="margin: .4rem 0rem 0rem 0rem; width: 100%; padding: 1.5rem 1rem; font-size: 2rem;">
              <small style="margin-bottom: 1rem; visibility: hidden;">Mensagem de Erro</small></div>`,
                confirmButtonText: 'Confirmar',
                confirmButtonColor: "#560085",
                cancelButtonText: 'Cancelar',
                cancelButtonColor: '#560085',
                showCancelButton: true,
                allowOutsideClick: false,
                preConfirm: () => {
                  const novaSenha = document.getElementById('novaSenha').value;
                  const confirmaNovaSenha = document.getElementById('confirmaNovaSenha').value;
                  if (novaSenha == "" || confirmaNovaSenha == "") {
                    //document.getElementById('novaSenhaError').style.visibility = 'visible';
                    //document.getElementById('confirmaNovaSenhaError').style.visibility = 'visible';
                    Swal.showValidationMessage('Defina a sua senha.');
                  }
                },
                didOpen: () => {
                  let novaSenha = document.querySelector("#novaSenha");
                  let confirmaNovaSenha = document.querySelector("#confirmaNovaSenha");
                  let smallNovaSenha = novaSenha.parentElement.querySelector("small");
                  let smallConfirmaNovaSenha = confirmaNovaSenha.parentElement.querySelector("small");
                  let btn = novaSenha.parentElement.parentElement.parentElement.querySelector(".swal2-confirm");
                  btn.setAttribute('disabled', 'disabled');

                  novaSenha.addEventListener("keyup", function() {
                    passwords(novaSenha, confirmaNovaSenha, smallNovaSenha, smallConfirmaNovaSenha, btn);
                  });

                  confirmaNovaSenha.addEventListener("keyup", function() {
                    passwords(novaSenha, confirmaNovaSenha, smallNovaSenha, smallConfirmaNovaSenha, btn);
                  });

                  function passwords(senha, confirmacao, smallSenha, smallCsenha, btn) {
                    if (senha.value != confirmacao.value) {
                      if (senha.value != "" && confirmacao.value != "") {
                        senha.className = "form-control is-invalid";
                        smallSenha.style.visibility = "visible";
                        smallSenha.style.color = "#dc3545";
                        smallSenha.innerText = "Senhas não coinscidem!";
                        confirmacao.className = "form-control is-invalid";
                        smallCsenha.style.visibility = "visible";
                        smallCsenha.style.color = "#dc3545";
                        smallCsenha.innerText = "Senhas não coinscidem!";
                        btn.setAttribute('disabled', 'disabled');
                      } else if (senha.value == '') {
                        senha.className = "form-control";
                        smallSenha.style.visibility = "hidden";
                        smallSenha.style.color = "#dc3545";
                        smallSenha.innerText = "Senhas não coinscidem!";
                        confirmacao.className = "form-control";
                        smallCsenha.style.visibility = "hidden";
                        smallCsenha.style.color = "#dc3545";
                        smallCsenha.innerText = "Senhas não coinscidem!";
                        btn.setAttribute('disabled', 'disabled');
                      } else if (confirmacao.value == '') {
                        senha.className = "form-control";
                        smallCsenha.style.visibility = "hidden";
                        smallCsenha.style.color = "#dc3545";
                        smallCsenha.innerText = "Senhas não coinscidem!";
                        confirmacao.className = "form-control";
                        smallSenha.style.visibility = "hidden";
                        smallSenha.style.color = "#dc3545";
                        smallSenha.innerText = "Senhas não coinscidem!";
                        btn.setAttribute('disabled', 'disabled');
                      }
                    } else if (senha.value == '' && confirmacao.value == '') {
                      senha.className = "form-control is-warning";
                      confirmacao.className = "form-control is-warning";
                      smallSenha.style.visibility = "visible";
                      smallSenha.style.color = "#ffc107";
                      smallSenha.innerText = "Campo obrigatório!";
                      smallCsenha.style.visibility = "visible";
                      smallCsenha.style.color = "#ffc107";
                      smallCsenha.innerText = "Campo obrigatório!";
                    } else if (senha.value == "") {
                      senha.className = "form-control is-warning";
                      smallSenha.innerText = "Campo obrigatório!";
                      smallSenha.style.color = "#ffc107";
                      smallSenha.style.visibility = "visible";
                      btn.setAttribute('disabled', 'disabled');
                    } else if (confirmacao.value == "") {
                      confirmacao.className = "form-control is-warning";
                      smallCsenha.innerText = "Campo obrigatório!";
                      smallCsenha.style.color = "#ffc107";
                      smallCsenha.style.visibility = "visible";
                      btn.setAttribute('disabled', 'disabled');
                    } else {
                      senha.className = "form-control is-valid";
                      confirmacao.className = "form-control is-valid";
                      smallSenha.style.visibility = "hidden";
                      smallCsenha.style.visibility = "hidden";
                      btn.removeAttribute('disabled');
                    }
                  }
                }
              }).then((result) => {
                if (result.isConfirmed) {
                  $.ajax({
                    url: "./includes/update/senha.inc.php",
                    type: "post",
                    dataType: "json",
                    data: {
                      idUsuario: nomeUsuarioEmail.value,
                      senha: novaSenha.value
                    },
                    success: function(data) {
                      console.log(data);
                      swal.fire({
                        title: "Senha definida com sucesso.",
                        text: "Senha do usuário " + nomeUsuarioEmail.value + " definida!",
                        confirmButtonText: 'Confirmar',
                        confirmButtonColor: '#560085',
                        icon: "success",
                      });
                    },
                    error: function() {
                      swal.fire({
                        title: "Erro ao definir senha.",
                        text: "Erro ao definir a Senha do usuário " + nomeUsuarioEmail.value + ".",
                        confirmButtonText: 'Confirmar',
                        confirmButtonColor: '#560085',
                        icon: "error",
                      });
                    }
                  });
                }
              });
            } else if (data == "credenciaisInvalidas") {
              console.log("Credênciais Invalidas");
              toastr.error('Nome de usuário/E-mail e ou senha inválidos.');
            } else if (data == "redefinirPalavraPasse") {
              swal.fire({
                title: `<div style="height: 7rem; width: 7rem; display: flex; justify-content: center; align-items: center; border: 1px solid #560085; border-radius: 50%; margin: 1rem;"><i class="fa-solid fa-lock" style="color: #560085d6;"></i></div><h1>Redefinição de senha.</h1>`,
                html: `
              <div style="text-align: center; display: flex; justify-content: center; flex-direction: column;"><label for="novaSenha">Digite a senha de redefinição</label>
              <input type="password" class="form-control" id="novaSenha" style="margin: .4rem 0rem 0rem 0rem; width: 100%; padding: 1.5rem 1rem; font-size: 2rem; padding: 1.5rem 1rem; font-size: 2rem;">
              <small style="margin-bottom: 1rem; visibility: hidden;">Mensagem de Erro</small></div>`,
                confirmButtonText: 'Confirmar',
                confirmButtonColor: "#560085",
                cancelButtonText: 'Cancelar',
                cancelButtonColor: '#560085',
                showCancelButton: true,
                allowOutsideClick: false,
                preConfirm: () => {
                  const novaSenha = document.getElementById('novaSenha').value;
                  if (novaSenha == "") {
                    Swal.showValidationMessage('Defina a sua senha.');
                  }
                },
                didOpen: () => {
                  let novaSenha = document.querySelector("#novaSenha");
                  let smallNovaSenha = novaSenha.parentElement.querySelector("small");
                  let btn = novaSenha.parentElement.parentElement.parentElement.querySelector(".swal2-confirm");
                  btn.setAttribute('disabled', 'disabled');

                  novaSenha.addEventListener("keyup", function() {
                    if (novaSenha.value == "") {
                      novaSenha.className = "form-control is-warning";
                      smallNovaSenha.style.visibility = "visible";
                      smallNovaSenha.style.color = "#ffc107";
                      smallNovaSenha.innerText = "Campo obrigatório!";
                      btn.setAttribute('disabled', 'disabled');
                    } else {
                      novaSenha.className = "form-control is-valid";
                      smallNovaSenha.style.visibility = "hidden";
                      btn.removeAttribute('disabled');
                    }
                  });
                }
              }).then((result) => {
                if (result.isConfirmed) {
                  funcaoQuerySelect("../pos/includes/querySelect.inc.php", "post", "json", {
                    nomeUsuario: nomeUsuarioEmail.value
                  }, "usuario", function success(data) {
                    const dadosUsuario = data;
                    $.ajax({
                      url: "../pos/includes/queryOtp.inc.php",
                      type: "post",
                      dataType: "json",
                      data: {
                        otp: dadosUsuario[0].otp,
                        senha: document.getElementById('novaSenha').value
                      },
                      success: function(data) {
                        if (data == 1) {
                          swal.fire({
                            title: `<div style="height: 7rem; width: 7rem; display: flex; justify-content: center; align-items: center; border: 1px solid #560085; border-radius: 50%; margin: 1rem;"><i class="fa-solid fa-lock" style="color: #560085d6;"></i></div><h1>Defina a sua senha.</h1>`,
                            html: `
              <div style="text-align: left;"><label for="novaSenha">Digite a sua senha</label>
              <input type="password" class="form-control" id="novaSenha" style="margin: .4rem 0rem 0rem 0rem; width: 100%; padding: 1.5rem 1rem; font-size: 2rem; padding: 1.5rem 1rem; font-size: 2rem;">
              <small style="margin-bottom: 1rem; visibility: hidden;">Mensagem de Erro</small></div>
              <div style="text-align: left;"><label for="confirmaNovaSenha">Confirme a sua senha</label>
              <input type="password" class="form-control" id="confirmaNovaSenha" style="margin: .4rem 0rem 0rem 0rem; width: 100%; padding: 1.5rem 1rem; font-size: 2rem;">
              <small style="margin-bottom: 1rem; visibility: hidden;">Mensagem de Erro</small></div>`,
                            confirmButtonText: 'Confirmar',
                            confirmButtonColor: "#560085",
                            cancelButtonText: 'Cancelar',
                            cancelButtonColor: '#560085',
                            showCancelButton: true,
                            allowOutsideClick: false,
                            preConfirm: () => {
                              const novaSenha = document.getElementById('novaSenha').value;
                              const confirmaNovaSenha = document.getElementById('confirmaNovaSenha').value;
                              if (novaSenha == "" || confirmaNovaSenha == "") {
                                //document.getElementById('novaSenhaError').style.visibility = 'visible';
                                //document.getElementById('confirmaNovaSenhaError').style.visibility = 'visible';
                                Swal.showValidationMessage('Defina a sua senha.');
                              }
                            },
                            didOpen: () => {
                              let novaSenha = document.querySelector("#novaSenha");
                              let confirmaNovaSenha = document.querySelector("#confirmaNovaSenha");
                              let smallNovaSenha = novaSenha.parentElement.querySelector("small");
                              let smallConfirmaNovaSenha = confirmaNovaSenha.parentElement.querySelector("small");
                              let btn = novaSenha.parentElement.parentElement.parentElement.querySelector(".swal2-confirm");
                              btn.setAttribute('disabled', 'disabled');

                              novaSenha.addEventListener("keyup", function() {
                                passwords(novaSenha, confirmaNovaSenha, smallNovaSenha, smallConfirmaNovaSenha, btn);
                              });

                              confirmaNovaSenha.addEventListener("keyup", function() {
                                passwords(novaSenha, confirmaNovaSenha, smallNovaSenha, smallConfirmaNovaSenha, btn);
                              });

                              function passwords(senha, confirmacao, smallSenha, smallCsenha, btn) {
                                if (senha.value != confirmacao.value) {
                                  if (senha.value != "" && confirmacao.value != "") {
                                    senha.className = "form-control is-invalid";
                                    smallSenha.style.visibility = "visible";
                                    smallSenha.style.color = "#dc3545";
                                    smallSenha.innerText = "Senhas não coinscidem!";
                                    confirmacao.className = "form-control is-invalid";
                                    smallCsenha.style.visibility = "visible";
                                    smallCsenha.style.color = "#dc3545";
                                    smallCsenha.innerText = "Senhas não coinscidem!";
                                    btn.setAttribute('disabled', 'disabled');
                                  } else if (senha.value == '') {
                                    senha.className = "form-control";
                                    smallSenha.style.visibility = "hidden";
                                    smallSenha.style.color = "#dc3545";
                                    smallSenha.innerText = "Senhas não coinscidem!";
                                    confirmacao.className = "form-control";
                                    smallCsenha.style.visibility = "hidden";
                                    smallCsenha.style.color = "#dc3545";
                                    smallCsenha.innerText = "Senhas não coinscidem!";
                                    btn.setAttribute('disabled', 'disabled');
                                  } else if (confirmacao.value == '') {
                                    senha.className = "form-control";
                                    smallCsenha.style.visibility = "hidden";
                                    smallCsenha.style.color = "#dc3545";
                                    smallCsenha.innerText = "Senhas não coinscidem!";
                                    confirmacao.className = "form-control";
                                    smallSenha.style.visibility = "hidden";
                                    smallSenha.style.color = "#dc3545";
                                    smallSenha.innerText = "Senhas não coinscidem!";
                                    btn.setAttribute('disabled', 'disabled');
                                  }
                                } else if (senha.value == '' && confirmacao.value == '') {
                                  senha.className = "form-control is-warning";
                                  confirmacao.className = "form-control is-warning";
                                  smallSenha.style.visibility = "visible";
                                  smallSenha.style.color = "#ffc107";
                                  smallSenha.innerText = "Campo obrigatório!";
                                  smallCsenha.style.visibility = "visible";
                                  smallCsenha.style.color = "#ffc107";
                                  smallCsenha.innerText = "Campo obrigatório!";
                                } else if (senha.value == "") {
                                  senha.className = "form-control is-warning";
                                  smallSenha.innerText = "Campo obrigatório!";
                                  smallSenha.style.color = "#ffc107";
                                  smallSenha.style.visibility = "visible";
                                  btn.setAttribute('disabled', 'disabled');
                                } else if (confirmacao.value == "") {
                                  confirmacao.className = "form-control is-warning";
                                  smallCsenha.innerText = "Campo obrigatório!";
                                  smallCsenha.style.color = "#ffc107";
                                  smallCsenha.style.visibility = "visible";
                                  btn.setAttribute('disabled', 'disabled');
                                } else {
                                  senha.className = "form-control is-valid";
                                  confirmacao.className = "form-control is-valid";
                                  smallSenha.style.visibility = "hidden";
                                  smallCsenha.style.visibility = "hidden";
                                  btn.removeAttribute('disabled');
                                }
                              }
                            }
                          }).then((result) => {
                            if (result.isConfirmed) {
                              funcaoUpdate("../pos/includes/update.inc.php", "post", "json", "usuario", {
                                otp: null
                              }, {
                                "idUsuario": dadosUsuario[0].idUsuario
                              }, success = (data) => {}, error = (data) => {

                              }, done = (data) => {

                              });
                              $.ajax({
                                url: "./includes/update/senha.inc.php",
                                type: "post",
                                dataType: "json",
                                data: {
                                  idUsuario: nomeUsuarioEmail.value,
                                  senha: novaSenha.value
                                },
                                success: function(data) {
                                  console.log(data);
                                  swal.fire({
                                    title: "Senha definida com sucesso.",
                                    text: "Senha do usuário " + nomeUsuarioEmail.value + " definida!",
                                    confirmButtonText: 'Confirmar',
                                    confirmButtonColor: '#560085',
                                    icon: "success",
                                  });
                                },
                                error: function() {
                                  swal.fire({
                                    title: "Erro ao definir senha.",
                                    text: "Erro ao definir a Senha do usuário " + nomeUsuarioEmail.value + ".",
                                    confirmButtonText: 'Confirmar',
                                    confirmButtonColor: '#560085',
                                    icon: "error",
                                  });
                                }
                              });
                            }
                          });
                        } else if (data == 0) {
                          swal.fire({
                            title: "Senha de redefinição incorrecta.",
                            text: "Digite a senha de redefinição que lhe foi data.",
                            confirmButtonText: 'Confirmar',
                            confirmButtonColor: '#560085',
                            icon: "error",
                          });
                        }
                      },
                      error: function(data) {

                      }
                    }).done((data) => {

                    });
                  }, function error(data) {

                  }, function done(data) {

                  });
                }
              });
            } else {
              toastr.success('Login Efectuado com sucesso.')

              function login() {
                window.location.href = "./main.php";
              }
              setTimeout(login, 500);
              console.log("Login sucesso");
            }
          },
          error: function(data) {
            console.log(data);
            console.log("Deu errado");
          }
        });
      });
    });
  </script>
</body>

</html>