<?php $page = 'familia';
include('header.php'); ?>

<body class="hold-transition layout-top-nav">
  <div class="wrapper">
    <div class="preloader flex-column justify-content-center align-items-center">
      <img class="animation__shake" src="images/logo/<?php echo $rows[9]['valor']; ?>" alt="AdminLTELogo" height="60" width="60">
    </div>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->
      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <!-- SELECT2 EXAMPLE -->
            <div class="col-md-2">
              <div class="card card-default" style="height: 60vh;">
                <div class="card-header">
                  <h3 class="card-title">Grupo de Usuário</h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body" style="overflow: auto;">
                  <div class="row">
                    <div class="col-md-12">
                      <table>
                        <tbody id="grupoUsuarioBody">
                        </tbody>
                      </table>
                    </div>
                    <!-- /.col -->
                  </div>
                  <!-- /.row -->
                </div>
              </div>
              
              <div class="form-group" style="margin-bottom: 0;">
                        <button class="btn btn-block btn-primary" id="btn-submit" name="btn-submit">Gravar Permissões</button>
                      </div>
            </div>
            <div class="col-md-10">
              <div class="card card-default">
                <div class="card-header">
                  <h3 class="card-title">Permissões</h3>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
                </div>
                <div class="card-body p-0" style="max-height: 86vh; overflow: auto;">
                  <table class="table table-striped">
                    <thead>
                      <tr>
                        <th>Identificador</th>
                        <th>Parâmetro</th>
                        <th>Cadastrar</th>
                        <th>Editar</th>
                        <th>Eliminar</th>
                        <th>Visualizar</th>
                      </tr>
                    </thead>
                    <tbody id="tabelaPermissaoBody">

                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
          <!-- /.card -->
        </div>
        <!-- /.container-fluid -->
      </section>
    </div>
    <!-- /.content-wrapper -->
    <?php include('footer.php'); ?>
</body>

</html>
<script src="./validation/tipoUsuario.js"></script>
<script>
  $(document).ready(function() {
    formTipoUsuarioButton();
    $.ajax({
      url: "includes/read/grupoUsuario.inc.php",
      type: "post",
      dataType: "json",
      success: function(data) {
        let select = "";
        for (var key in data) {
          select += `
          <tr>
            <td style="border: 0; width: 70%; vertical-align: middle;">
              <div class="custom-control custom-checkbox">
                <input class="custom-control-input" type="checkbox" id="${data[key]['idGrupoUsuario']}" value="0">
                <label for="${data[key]['idGrupoUsuario']}" class="custom-control-label">${data[key]['nome']}</label>
              </div>
            </td>
          </tr>`;
        }
        $("#grupoUsuarioBody").html(select);
      }
    });
    $.ajax({
      url: "includes/read/permissao.inc.php",
      type: "post",
      dataType: "json",
      success: function(data) {
        console.log(data);
        let select = "";
        for (var key in data) {
          select += `
          <tr>
            <td>${data[key]["idPermissao"]}</td>
            <td>${data[key]["nome"]}</td>
            ${data[key]["create"] == 1 ? `<td>
              <div class="custom-control custom-switch">
                <input type="checkbox" class="custom-control-input" name="${data[key]["idPermissao"] + data[key]["nome"]}" id="${data[key]["idPermissao"] + "- create"}" checked>
                <label class="custom-control-label" for="${data[key]["idPermissao"] + "- create"}"></label>
              </div>
            </td>` : `<td>
              <div class="custom-control custom-switch">
                <input type="checkbox" class="custom-control-input" name="${data[key]["idPermissao"] + data[key]["nome"]}" id="${data[key]["idPermissao"] + "- create"}">
                <label class="custom-control-label" for="${data[key]["idPermissao"] + "- create"}"></label>
              </div>
            </td>`}
            ${data[key]["read"] == 1 ? `<td>
              <div class="custom-control custom-switch">
                <input type="checkbox" class="custom-control-input" name="${data[key]["idPermissao"] + data[key]["nome"]}" id="${data[key]["idPermissao"] + "- read"}" checked>
                <label class="custom-control-label" for="${data[key]["idPermissao"] + "- read"}"></label>
              </div>
            </td>` : `<td>
              <div class="custom-control custom-switch">
                <input type="checkbox" class="custom-control-input" name="${data[key]["idPermissao"] + data[key]["nome"]}" id="${data[key]["idPermissao"] + "- read"}">
                <label class="custom-control-label" for="${data[key]["idPermissao"] + "- read"}"></label>
              </div>
            </td>`}
            ${data[key]["update"] == 1 ? `<td>
              <div class="custom-control custom-switch">
                <input type="checkbox" class="custom-control-input" name="${data[key]["idPermissao"] + data[key]["nome"]}" id="${data[key]["idPermissao"] + "- update"}" checked>
                <label class="custom-control-label" for="${data[key]["idPermissao"] + "- update"}"></label>
              </div>
            </td>` : `<td>
              <div class="custom-control custom-switch">
                <input type="checkbox" class="custom-control-input" name="${data[key]["idPermissao"] + data[key]["nome"]}" id="${data[key]["idPermissao"] + "- update"}">
                <label class="custom-control-label" for="${data[key]["idPermissao"] + "- update"}"></label>
              </div>
            </td>`}
            ${data[key]["delete"] == 1 ? `<td>
              <div class="custom-control custom-switch">
                <input type="checkbox" class="custom-control-input" name="${data[key]["idPermissao"] + data[key]["nome"]}" id="${data[key]["idPermissao"] + "- delete"}" checked>
                <label class="custom-control-label" for="${data[key]["idPermissao"] + "- delete"}"></label>
              </div>
            </td>` : `<td>
              <div class="custom-control custom-switch">
                <input type="checkbox" class="custom-control-input" name="${data[key]["idPermissao"] + data[key]["nome"]}" id="${data[key]["idPermissao"] + "- delete"}">
                <label class="custom-control-label" for="${data[key]["idPermissao"] + "- delete"}"></label>
              </div>
            </td>`}
          </tr>`;
        }
        $("#tabelaPermissaoBody").html(select);
      }
    });
  });

  $(document).on("click", "#btn-submit", function(e) {
    e.preventDefault();
    if (nome.value != '') {
      $.ajax({
        url: "includes/create/tipoUsuario.inc.php",
        type: "post",
        data: {
          nome: nome.value,
          nota: nota.value
        },
        success: function(data) {
          swal.fire({
            title: "Cadastro efectuado com sucesso!",
            text: "Permissões " + nome.value + " cadastrado!",
            confirmButtonText: 'Confirmar',
            icon: "success",
          });
          nome.value = "";
          nome.className = "form-control";
          nota.value = "";
          nota.className = "form-control";
        },
        error: function(data) {
          swal.fire({
            title: "Erro ao Cadastrar Permissões!",
            text: "Erro ao Cadastrar Permissões: " + nome.value + " !",
            confirmButtonText: 'Confirmar',
            icon: "error",
          });
        }
      }).done(function(data) {
        console.log(data);
      });
    }
  });
</script>