<?php include('header.php'); ?>

<body class="hold-transition layout-top-nav">
  <div class="wrapper">
    <div class="preloader flex-column justify-content-center align-items-center">
      <img class="animation__shake" src="images/logo/<?php echo $rows[9]['valor']; ?>" alt="AdminLTELogo" height="60" width="60">
    </div>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <!-- SELECT2 EXAMPLE -->
            <div class="col-md-8">
              <div class="card card-default">
                <div class="card-header">
                  <h3 class="card-title">Entidade</h3>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                  <div class="row">
                    <div class="col-md-3" style="text-align: -webkit-center;">
                      <div class="form-group margem">
                        <div class="wrapper-image">
                          <div class="image-container image-info-profile">
                            <i class="fas fa-image"></i>
                          </div>
                          <label for="file" class="camera-icon" id="labelFoto">
                            <i class="fas fa-camera"></i>
                          </label>
                          <input type="file" id="file" name="file" accept="image/*" hidden>
                        </div>
                      </div>
                    </div>
                    <div class="col-md-3">
                      <div class="form-group margem" style="margin-bottom: 0;">
                        <small class="not-required">Código</small>
                        <div class="input-group input-group">
                          <input type="text" class="form-control form-control" id="codigo" name="codigo" placeholder="Pesquisar Entidade" title="Pesquisar Entidade" disabled>
                          <div class="input-group-append">
                            <button type="button" id="btn-search" class="btn btn btn-default" style="line-height: 0 ;">
                              <i class="fa fa-search"></i>
                            </button>
                          </div>
                        </div>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-3">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Tipo de Entidade</small>
                        <select class="form-control select2" style="width: 100%;" id="idTipoEntidade" name="idTipoEntidade">
                          <option value="0">Selecione um Tipo de Entidade</option>
                        </select>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-3">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="not-required">Tipo Alternativo (Opcional)</small>
                        <select class="form-control select2" style="width: 100%;" id="tipoAlternativo" name="tipoAlternativo">
                          <option value="0">Selecione um Tipo Alternativo</option>
                        </select>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Nome Completo</small>
                        <input type="text" class="form-control" id="nome" name="nome" placeholder="Nome Completo" title="Nome Completo" required>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Número de Identificação Fiscal (NIF)</small>
                        <input type="text" class="form-control" id="nif" name="nif" placeholder="Número de Identificação Fiscal (NIF)" title="NIF (Número de Identificação Fiscal)" required>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-bottom: 0;">
                        <small>Botão</small>
                        <button class="btn btn-block btn-primary" id="btn-submit" name="btn-submit">Cadastrar Entidade</button>
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Nome Comercial</small>
                        <input type="text" class="form-control" id="nomeComercial" name="nomeComercial" placeholder="Nome Comercial" title="Nome Comercial" required>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="not-required">Localidade (Opcional)</small>
                        <input type="text" class="form-control" id="localidade" name="localidade" placeholder="Localidade" title="Localidade" required>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="not-required">Morada (Opcional)</small>
                        <textarea class="form-control" rows="1" id="morada" name="morada" placeholder="Morada" title="Morada" required></textarea>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="not-required">Bilhete de Identidade (Opcional)</small>
                        <input type="text" class="form-control" id="bi" name="bi" placeholder="Bilhete de Identidade" title="Bilhete de Identidade" required>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="not-required">Data de Nascimento (Opcional)</small>
                        <input type="date" class="form-control" id="dataNasc" name="dataNasc" placeholder="Data de Nascimento" title="Data de Nascimento" required>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-top: .4rem;">
                        <small>Mensagem de erro</small>
                        <div class="custom-control custom-switch">
                          <input type="checkbox" class="custom-control-input" name="estado" id="estado">
                          <label class="custom-control-label" for="estado">Estado - Activo</label>
                        </div>
                      </div>
                    </div>
                    <!-- /.col -->
                  </div>
                  <!-- /.row -->
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                  Cadastre as Informações do Entidade.
                </div>
              </div>
            </div>
          </div>
          <!-- /.card -->
        </div>
        <!-- /.container-fluid -->
      </section>
    </div>
    <!-- /.content-wrapper -->
    <?php include('footer.php'); ?>
</body>

</html>
<script src="./validation/entidade.js"></script>
<script>
  let pagina;
  let resizedImage;

  var stringLocalStorage = localStorage.getItem('pagina');
  var valorJS = JSON.parse(stringLocalStorage);

  $(document).ready(function() {
    formEntidadeButton();
    console.log("Aqui: ", valorJS);
  });

  let urlToFile = (url) => {
    let arr = url.split(",");
    let mime = arr[0].match(/:(.*?);/)[1];
    let data = arr[1];

    let dataString = atob(data);
    let n = dataString.length;
    let dataArr = new Uint8Array(n);
    while (n--) {
      dataArr[n] = dataString.charCodeAt(n);
    }
    let file = new File([dataArr], 'File.jpg', {
      type: mime
    });
    return file;
  }

  $(document).ready(function() {
    const img_input = document.querySelector("#file");
    img_input.addEventListener("change", function() {
      const reader = new FileReader();
      reader.addEventListener("load", () => {
        const imgElement = document.createElement("img");
        imgElement.src = reader.result;
        imgElement.onload = function(e) {
          const canvas = document.createElement("canvas");
          const MAX_WIDTH = 400;
          const scaleSize = MAX_WIDTH / e.target.width;
          canvas.width = MAX_WIDTH;
          canvas.height = e.target.height * scaleSize;
          const ctx = canvas.getContext("2d");
          ctx.drawImage(e.target, 0, 0, canvas.width, canvas.height);

          const srcEncoded = ctx.canvas.toDataURL(e.target, "image/jpeg");
          resizedImage = urlToFile(srcEncoded);
        }

        const uploaded_image = reader.result;
        document.querySelector(".image-container").style.backgroundImage = `url(${uploaded_image})`;

        let botao = document.getElementById("labelFoto");
        botao.innerHTML = `<i class="fas fa-close"></i>`;
      });
      reader.readAsDataURL(this.files[0]);
      document.querySelector(".image-container").querySelector("i").style.display = "none";
    });
  });

  $(document).on("click", "#labelFoto", function(e) {
    let img = $("#file")[0].files;
    if (img[0] != null) {
      //e.preventDefault();
      document.querySelector(".image-container").style.backgroundImage = "none";
      document.querySelector(".image-container").querySelector("i").style.display = "block";
      this.innerHTML = `<i class="fas fa-camera"></i>`;
      console.log("Mudei");
    }
  });

  $(document).on("click", "#btn-search", function(e) {
    e.preventDefault();
    console.log("Cliquei");
    if (codigo.disabled) {
      codigo.disabled = false;
    } else {
      codigo.disabled = true;
    }
  });

  $(document).on("change", "#idTipoEntidade", function(e) {
    tipoAlternativoSelect();
  });

  $(document).on("change", "#estado", function(e) {
    e.preventDefault();
    var labelEstado = document.querySelector("label[for='estado']");
    if (estado.checked == true) {
      estado.value = 1;
      labelEstado.innerText = "Estado - Inactivo";
    } else {
      estado.value = 0;
      labelEstado.innerText = "Estado - Activo";
    }
  });
  $(document).ready(function() {
    codigoEntidade();
    //formEntidadeButton();
  });


  $(document).ready(function() {
    $.ajax({
      url: "includes/read/tipoEntidade.inc.php",
      type: "post",
      dataType: "json",
      success: function(data) {
        let select = "";
        select += "<option value='0'>Selecione um Tipo de Entidade</option>";
        for (var key in data) {
          select += "<option value=" + data[key]['idTipoEntidade'] + ">" + data[key]['nome'] + "</option>";
        }
        $("#idTipoEntidade").html(select);
      }
    }).done(function() {
      if (valorJS == "fornecedor") {
        $('#idTipoEntidade').val(1);
        $('#idTipoEntidade').select2().trigger('change');
        idTipoEntidade.disabled = true;
      } else if (valorJS == "cliente") {
        $('#idTipoEntidade').val(2);
        $('#idTipoEntidade').select2().trigger('change');
        idTipoEntidade.disabled = true;
      }
    });
  });

  $(document).ready(function() {
    tipoAlternativoSelect();
  });

  function tipoAlternativoSelect() {
    $.ajax({
      url: "includes/read/tipoEntidade.inc.php",
      type: "post",
      dataType: "json",
      success: function(data) {
        console.log("Tipos: ", data);
        let select = "";
        select += "<option value='0'>Selecione um Tipo Alternativo</option>";
        for (var key in data) {
          if (idTipoEntidade.value == data[key]['idTipoEntidade']) {
            select += "<option disabled='disabled' value=" + data[key]['idTipoEntidade'] + ">" + data[key]['nome'] + "</option>";
          } else {
            select += "<option value=" + data[key]['idTipoEntidade'] + ">" + data[key]['nome'] + "</option>";
          }
        }
        $("#tipoAlternativo").html(select);
      }
    });
  }

  $(document).on("click", "#btn-submit", function(e) {
    e.preventDefault();
    console.log("CLiquei no botão!");
    if (nome.value != '' && nomeComercial.value != '' && nif.value != '' && idTipoEntidade.value != 0) {
      let img = $("#file")[0].files;
      entidade(img);
    }
  });

  function foto(identificador, img) {
    let form_data = new FormData();
    form_data.append('id', identificador);
    form_data.append('imagem', resizedImage);

    $.ajax({
      url: "includes/create/fotoEntidade.inc.php",
      type: "post",
      data: form_data,
      cache: false,
      contentType: false,
      processData: false,
      success: function(data) {
        console.log(data);
        let btnCamera = document.getElementById("labelFoto");
        let container = document.querySelector(".image-container");
        container.style.backgroundImage = "none";
        container.querySelector("i").style.display = "block";
        btnCamera.innerHTML = `<i class="fas fa-camera"></i>`;
      }
    });
  }

  function entidade(img) {
    $.ajax({
      url: "includes/create/entidade.inc.php",
      type: "post",
      data: {
        idUsuario: <?php echo $_SESSION["usuarioId"]; ?>,
        idTipoEntidade: idTipoEntidade.value,
        tipoAlternativo: tipoAlternativo.value,
        nome: nome.value,
        nomeComercial: nomeComercial.value,
        bi: bi.value,
        nif: nif.value,
        localidade: localidade.value,
        dataNasc: dataNasc.value,
        morada: morada.value,
        estado: estado.value
      },
      success: function(data) {
        codigoEntidade();
        swal.fire({
          title: "Cadastro efectuado com sucesso!",
          text: "Entidade " + nome.value + " cadastrado!",
          confirmButtonText: 'Confirmar',
          icon: "success",
        });
        if (img[0] != null) {
          foto(data, img);
        }
        $('#idTipoEntidade').val(0);
        $('#idTipoEntidade').select2().trigger('change');
        $('#tipoAlternativo').val(0);
        $('#tipoAlternativo').select2().trigger('change');
        nome.value = "";
        nome.className = "form-control";
        nomeComercial.value = "";
        nomeComercial.className = "form-control";
        bi.value = "";
        bi.className = "form-control";
        nif.value = "";
        nif.className = "form-control";
        localidade.value = "";
        localidade.className = "form-control";
        dataNasc.value = "";
        dataNasc.className = "form-control";
        morada.value = "";
        morada.className = "form-control";
        estado.checked = false;
        estado.value = 0;

        let smallIdTipoEntidade = idTipoEntidade.parentElement.querySelectorAll("small")[1];
        smallIdTipoEntidade.style.visibility = "hidden";
        let smallTipoAlternativo = tipoAlternativo.parentElement.querySelectorAll("small")[1];
        smallTipoAlternativo.style.visibility = "hidden";
      },
      error: function(data) {
        swal.fire({
          title: "Erro ao cadastrar Entidade!",
          text: "Erro ao cadastrar Entidade: " + nome.value + " !",
          confirmButtonText: 'Confirmar',
          icon: "error",
        });
      }
    }).done(function(data) {
      console.log(data);
    });
  }
</script>