<?php
class TipoUsuarioModel extends Database
{

	protected function insertTipoUsuario($nome, $nota)
	{
		$stmt = $this->connect();
		$sql = "INSERT INTO tipoUsuario (nome, nota) VALUES (?, ?)";
		$query = $stmt->prepare($sql);
		if (!($query->execute(array($nome, $nota)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	public function listagemTipoUsuario()
	{
		$data = null;
		$sql = "SELECT * FROM tipoUsuario";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryTipoUsuario($idTipoUsuario)
	{
		$data = null;
		$sql = "SELECT * FROM tipoUsuario WHERE idTipoUsuario = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idTipoUsuario]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryTipoTaxa($idTipoTaxa)
	{
		$data = null;
		$sql = "SELECT * FROM tipotaxa WHERE idTipoTaxa = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idTipoTaxa]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listaTipoTaxa()
	{
		$data = null;
		$sql = "SELECT * FROM tipotaxa";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	protected function editTipoUsuario($idTipoUsuario, $nome, $nota)
	{
		$stmt = $this->connect();

		$sql = "UPDATE tipoUsuario SET nome = ?, nota = ? WHERE idTipoUsuario = ?";
		$query = $stmt->prepare($sql);

		if (!($query->execute(array($nome, $nota, $idTipoUsuario)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	public function deleteTipoUsuario($idTipoUsuario)
	{
		$stmt = $this->connect();
		$sql = "DELETE FROM tipoUsuario WHERE idTipoUsuario = ?";
		$query = $stmt->prepare($sql);
		if (!($query->execute(array($idTipoUsuario)))) {
			$query = null;
			exit();
		}
	}

	public function autoIncrementTipoUsuario()
	{
		$sql = "SELECT `AUTO_INCREMENT` AS contador
			FROM INFORMATION_SCHEMA.TABLES
			WHERE TABLE_SCHEMA = 'test1234'
			AND TABLE_NAME = 'tipoUsuario';";
		$stmt = $this->connect()->query($sql);
		$results = $stmt->fetch();
		return $results['contador'];
	}
}
