<?php

class TipoTaxaModel extends Database {

	protected function insertTipoTaxa($codigo, $descricao){
		$stmt = $this->connect();
		$sql = "INSERT INTO tipoTaxa (codigo, descricao) VALUES (?, ?)";
		$query = $stmt->prepare($sql);
		if(!($query->execute(array($codigo, $descricao)))){
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

		protected function editTipoTaxa($idTipoTaxa, $codigo, $descricao){
			$sql = "UPDATE tipoTaxa SET codigo = ?, descricao = ? WHERE idTipoTaxa = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute(array($codigo, $descricao, $idTipoTaxa))){
				$stmt = null;
				exit();
			}
			$stmt = null;
		}
		
		public function parentTipoTaxa(){
			$data = null;
			$sql = "SELECT * FROM tipoTaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function readCodigoTipoTaxa(){
			$data = null;
			$sql = "SELECT COALESCE(MAX(idTipoTaxa), 0) + 1 AS contador FROM tipoTaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryTipoTaxa($idTipoTaxa){
			$data = null;
			$sql = "SELECT * FROM tipoTaxa WHERE idTipoTaxa = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTipoTaxa]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function listagemTipoTaxa(){
			$data = null;
			$sql = "SELECT * FROM tipoTaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function deleteTipoTaxa($idTipoTaxa){
			$sql = "DELETE FROM tipoTaxa WHERE idTipoTaxa = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute([$idTipoTaxa])){
				$stmt = null;
				exit();
			}
			$stmt = null;
		}

		protected function funcaoReadTipoTaxa(){
			$sql = "SELECT * FROM tipoTaxa";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<option name="idTipoTaxa" value="'.$row['idTipoTaxa'].'">' . $row['codigo'] . '</option>';//'<option value='"$row['idTipoTaxa']"'>'"$row['codigo']"'</option>';
				//echo $row['idUsuario'];
				//echo $row['codigo'];
			}

		}

		protected function listaTipoTaxa(){
			$sql = "SELECT * FROM tipoTaxa";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<tr>
					<td>'.$row['idTipoTaxa'].'</td>
					<td>'.$row['codigo'].'</td>
					<td>
						<a href="../includes/TipoTaxaUpdate.inc.php?id='.$row['idTipoTaxa'].'" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../includes/TipoTaxaDelete.inc.php?id='.$row['idTipoTaxa'].'"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
			}

		}

		protected function countTipoTaxa(){
			$sql = "SELECT COUNT(*) FROM tipoTaxa";
			$stmt = $this->connect()->query($sql);
			$results = $stmt->fetch();
			echo $results['COUNT(*)'];
		}
	}