<?php

class TipoEntidadeModel extends Database
{

	protected function insertTipoEntidade($idUsuario, $nome, $nota)
	{
		$stmt = $this->connect();
		$sql = "INSERT INTO tipoEntidade (idUsuario, nome, nota) VALUES (?, ?, ?)";
		$query = $stmt->prepare($sql);
		if (!($query->execute(array($idUsuario, $nome, $nota)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function editTipoEntidade($idTipoEntidade, $idUsuario, $nome, $nota)
	{
		$sql = "UPDATE tipoEntidade SET idUsuario = ?, nome = ?, nota = ? WHERE idTipoEntidade = ?";
		$stmt = $this->connect()->prepare($sql);
		if (!$stmt->execute(array($idUsuario, $nome, $nota, $idTipoEntidade))) {
			$stmt = null;
			exit();
		}
		$stmt = null;
	}

	public function parentTipoEntidade()
	{
		$data = null;
		$sql = "SELECT * FROM tipoEntidade";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function readCodigoTipoEntidade()
	{
		$data = null;
		$sql = "SELECT COALESCE(MAX(idTipoEntidade), 0) + 1 AS contador FROM tipoEntidade";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryTipoEntidade($idTipoEntidade)
	{
		$data = null;
		$sql = "SELECT * FROM tipoEntidade WHERE idTipoEntidade = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idTipoEntidade]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listagemTipoEntidade()
	{
		$data = null;
		$sql = "SELECT * FROM tipoEntidade";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function deleteTipoEntidade($idTipoEntidade)
	{
		$sql = "DELETE FROM tipoEntidade WHERE idTipoEntidade = ?";
		$stmt = $this->connect()->prepare($sql);
		if (!$stmt->execute([$idTipoEntidade])) {
			$stmt = null;
			exit();
		}
		$stmt = null;
	}

	protected function selectTipoEntidade()
	{
		$sql = "SELECT * FROM tipoEntidade";
		$stmt = $this->connect()->query($sql);
		while ($row = $stmt->fetch()) {

			echo '<option name="idTipoEntidade" value="' . $row['idTipoEntidade'] . '">' . $row['nome'] . '</option>'; //'<option value='"$row['idTipoEntidade']"'>'"$row['nome']"'</option>';
			//echo $row['idUsuario'];
			//echo $row['nome'];
		}
	}

	protected function listaTipoEntidade()
	{
		$sql = "SELECT * FROM tipoEntidade";
		$stmt = $this->connect()->query($sql);
		while ($row = $stmt->fetch()) {

			echo '<tr>
					<td>' . $row['idTipoEntidade'] . '</td>
					<td>' . $row['nome'] . '</td>
					<td>
						<a href="../includes/TipoEntidadeUpdate.inc.php?id=' . $row['idTipoEntidade'] . '" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../includes/TipoEntidadeDelete.inc.php?id=' . $row['idTipoEntidade'] . '"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
		}
	}

	public function autoIncrementTipoEntidade()
	{
		$sql = "SELECT `AUTO_INCREMENT` AS contador
			FROM INFORMATION_SCHEMA.TABLES
			WHERE TABLE_SCHEMA = 'test1234'
			AND TABLE_NAME = 'tipoEntidade';";
		$stmt = $this->connect()->query($sql);
		$results = $stmt->fetch();
		return $results['contador'];
	}

	protected function countTipoEntidade()
	{
		$sql = "SELECT COUNT(*) FROM tipoEntidade";
		$stmt = $this->connect()->query($sql);
		$results = $stmt->fetch();
		echo $results['COUNT(*)'];
	}
}
