<?php
    class TipoDocModel extends Database {

		protected function insertTipoDoc($codigo, $nome, $tipoDocumento, $natureza, $operacaoStock, $operacaoContaCorrente, $tipoEnt, $operacaoCaixa){
			$stmt = $this->connect();
            $sql = "INSERT INTO tipoDoc (codigo, nome, tipoDocumento, natureza, operacaoStock, operacaoContaCorrente, operacaoCaixa, operacaoMovimentar, tipoDoc, tipoEnt, docRelac, saft, estado) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($codigo, $nome, "compra", 'natureza', 'compra', 'debito', 'credito', "semAccao", null, $tipoEnt, null, 0, 1,)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemTipoDoc(){
			$data = null;
			$sql = "SELECT * FROM tipoDoc;";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function editTipoDoc($idTipoDoc, $codigo, $nome){
			$stmt = $this->connect();
			
            $sql = "UPDATE tipoDoc SET codigo = ?, nome = ? WHERE idTipoDoc = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($codigo, $nome, $idTipoDoc)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function deleteTipoDoc($idTipoDoc){
			$stmt = $this->connect();
            $sql = "DELETE FROM tipoDoc WHERE idTipoDoc = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idTipoDoc)))){
				$query = null;
				exit();
			}
		}

		public function queryTipoDoc($idTipoDoc){
			$data = null;
			$sql = "SELECT * FROM tipoDoc WHERE idTipoDoc = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTipoDoc]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}
    }