<?php

class SerieModel extends Database {

	protected function insertSerie($codigo, $descricao){
		$stmt = $this->connect();
		$sql = "INSERT INTO serie (codigo, descricao) VALUES (?, ?)";
		$query = $stmt->prepare($sql);
		if(!($query->execute(array($codigo, $descricao)))){
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

		protected function editSerie($idSerie, $codigo, $descricao){
			$sql = "UPDATE serie SET codigo = ?, descricao = ? WHERE idSerie = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute(array($codigo, $descricao, $idSerie))){
				$stmt = null;
				exit();
			}
			$stmt = null;
		}
		
		public function parentSerie(){
			$data = null;
			$sql = "SELECT * FROM serie";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function readCodigoSerie(){
			$data = null;
			$sql = "SELECT COALESCE(MAX(idSerie), 0) + 1 AS contador FROM serie";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function querySerie($idSerie){
			$data = null;
			$sql = "SELECT * FROM serie WHERE idSerie = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idSerie]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function listagemSerie(){
			$data = null;
			$sql = "SELECT * FROM serie";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function deleteSerie($idSerie){
			$sql = "DELETE FROM serie WHERE idSerie = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute([$idSerie])){
				$stmt = null;
				exit();
			}
			$stmt = null;
		}

		protected function selectSerie(){
			$sql = "SELECT * FROM serie";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<option name="idSerie" value="'.$row['idSerie'].'">' . $row['codigo'] . '</option>';//'<option value='"$row['idSerie']"'>'"$row['codigo']"'</option>';
				//echo $row['idUsuario'];
				//echo $row['codigo'];
			}

		}

		protected function listaSerie(){
			$sql = "SELECT * FROM serie";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<tr>
					<td>'.$row['idSerie'].'</td>
					<td>'.$row['codigo'].'</td>
					<td>
						<a href="../includes/SerieUpdate.inc.php?id='.$row['idSerie'].'" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../includes/SerieDelete.inc.php?id='.$row['idSerie'].'"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
			}

		}

		protected function countSerie(){
			$sql = "SELECT COUNT(*) FROM serie";
			$stmt = $this->connect()->query($sql);
			$results = $stmt->fetch();
			echo $results['COUNT(*)'];
		}
	}