<?php
class SensorModel extends Database
{

	protected function insertSensor($sensor1, $sensor2)
	{
		$dados = $this->pegar();
		if ($dados["COUNT(*)"] > 0) {
			$info = $this->listagemSensor();
			for ($i = 0; $i < count($info); $i++) {

				$stmt = $this->connect();

				$sql = "UPDATE sensor SET sensor1 = ?, sensor2 = ?, dataActual = current_timestamp WHERE idSensor = ?";
				$query = $stmt->prepare($sql);

				if (!($query->execute(array($sensor1, $sensor2, $info[$i]["idSensor"])))) {
					$query = null;
					exit();
				}
			}
			$resposta = $this->getSensor();
			return $resposta;
		} else {
			$stmt = $this->connect();
			$sql = "INSERT INTO sensor (sensor1, sensor2) VALUES (?, ?)";
			$query = $stmt->prepare($sql);

			if (!($query->execute(array($sensor1, $sensor2)))) {
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
		}
	}

	public function getSensor()
	{
		$data = null;
		$sql = "SELECT * FROM sensor;";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data = $row;
			}
		}
		return $data;
	}

	public function pegar()
	{
		$data = null;
		$sql = "SELECT COUNT(*) FROM sensor;";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data = $row;
			}
		}
		return $data;
	}

	public function listagemSensor()
	{
		$data = null;
		$sql = "SELECT * FROM sensor;";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	protected function editSensor($idSensor, $sensor1, $sensor2, $onoff)
	{
		$stmt = $this->connect();

		$sql = "UPDATE sensor SET sensor1 = ?, sensor2 = ?, onoff = ? WHERE idSensor = ?";
		$query = $stmt->prepare($sql);

		if (!($query->execute(array($sensor1, $sensor2, $onoff, $idSensor)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function editShutDown($idSensor, $onoff, $prensa)
	{
		$stmt = $this->connect();

		$sql = "UPDATE sensor SET onoff = ?, prensa = ? WHERE idSensor = ?";
		$query = $stmt->prepare($sql);

		if (!($query->execute(array($onoff, $prensa, $idSensor)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function editGaveta($idSensor, $gaveta)
	{
		$stmt = $this->connect();

		$sql = "UPDATE sensor SET gaveta = ? WHERE idSensor = ?";
		$query = $stmt->prepare($sql);

		if (!($query->execute(array($gaveta, $idSensor)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function editSensorOnOff($idSensor, $onoff)
	{
		$stmt = $this->connect();

		$sql = "UPDATE sensor SET onoff = ? WHERE idSensor = ?";
		$query = $stmt->prepare($sql);

		if (!($query->execute(array($onoff, $idSensor)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function editPrensa($idSensor, $prensa)
	{
		$stmt = $this->connect();

		$sql = "UPDATE sensor SET prensa = ? WHERE idSensor = ?";
		$query = $stmt->prepare($sql);

		if (!($query->execute(array($prensa, $idSensor)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	public function deleteSensor($idSensor)
	{
		$stmt = $this->connect();
		$sql = "DELETE FROM sensor WHERE idSensor = ?";
		$query = $stmt->prepare($sql);
		if (!($query->execute(array($idSensor)))) {
			$query = null;
			exit();
		}
	}

	public function querySensor($idSensor)
	{
		$data = null;
		$sql = "SELECT * FROM sensor WHERE idSensor = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idSensor]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}
}
