<?php

class MaisModel extends Database {

		protected function insertMais($idCarro, $km, $tipo, $assento, $porta, $combustivel, $nBagagem, $descricao){
			$sql = "INSERT INTO mais (idCarro, km, tipo, assento, porta, combustivel, bagagem, descricao) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute(array($idCarro, $km, $tipo, $assento, $porta, $combustivel, $nBagagem, $descricao))){
				$stmt = null;
				header("location: ../carroForm.php?Erro=Inserir!");
				exit();
			}
			$stmt = null;
		}

		public function deleteMais($idMais){
			$sql = "DELETE FROM mais WHERE idMais = ?";
			$stmt = $this->connect()->prepare($sql);
			$stmt->execute([$idMais]);
		}

		protected function readMais(){
			$sql = "SELECT * FROM mais";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){
				$row['idMais'];
				$row['idUsuario'];
				$row['idCarro'];
				$row['km'];
				$row['tipo'];
				$row['acento'];
				$row['porta'];
				$row['combustivel'];
				$row['bagagem'];
				$row['descricao'];
			}
		}

		protected function updateMais($idCarro, $km, $tipo, $acento, $porta, $combustivel, $nBagagem, $descricao, $idMais){
			$sql = "UPDATE mais SET idCarro = ?, km = ?, tipo = ?, acento = ?, porta = ?, combustivel = ?, bagagem = ?, descricao = ? WHERE idMais = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute(array($idCarro, $km, $tipo, $acento, $porta, $combustivel, $nBagagem, $descricao, $idMais))){
				$stmt = null;
				header("location: ../forms/carroForm.php?Erro=Editar!");
				exit();
			}
			$stmt = null;
		}

		/*protected function deleteMais($idMais){
			$sql = "DELETE FROM mais WHERE idMais = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!stmt->execute(array($idMais))){
				$stmt = null;
				header("location: ../forms/carroForm.php?Erro=Eliminar!");
				exit();
			}
			$stmt = null;
		}*/

		protected function listaMais(){
			$sql = "SELECT * FROM viewMaisCarro";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<tr>
					<td>'.$row['idMais'].'</td>
					<td>'.$row['km'].'</td>
					<td>'.$row['tipo'].'</td>
					<td>'.$row['acento'].'</td>
					<td>'.$row['porta'].'</td>
					<td>'.$row['combustivel'].'</td>
					<td>'.$row['bagagem'].'</td>
					<td>'.$row['descricao'].'</td>
					<td>'.$row['idCarro'].'</td>
					<td>'.$row['nomeCarro'].'</td>
					<td>'.$row['carroEstado'].'</td>

					<td>
						<a href="../includes/maisUpdate.inc.php?'.$row['idMais'].'" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../admin/includes/maisDelete.inc.php?'.$row['idMais'].'"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
			}

		}
	}