<?php
    class ItemStockModel extends Database {

		protected function insertItemStock($idDocumento, $idArtigo, $descricao, $qtdDisponivel, $qtd, $preco){
            $stmt = $this->connect();
            $sql = "INSERT INTO itemStock (idDocumento, idArtigo, descricao, qtdDisponivel, qtd, preco) VALUES (?, ?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idDocumento, $idArtigo, $descricao, $qtdDisponivel, $qtd, $preco)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		protected function insertItemStockSaida($idDocumento, $idArtigo, $descricao, $qtdDisponivel, $qtd, $preco){
            $stmt = $this->connect();
            $sql = "INSERT INTO itemStockSaida (idDocumento, idArtigo, descricao, qtdDisponivel, qtd, preco) VALUES (?, ?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idDocumento, $idArtigo, $descricao, $qtdDisponivel, $qtd, $preco)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		protected function insertItemStockInventario($idDocumento, $idArtigo, $descricao, $qtdDisponivel, $qtd, $preco){
            $stmt = $this->connect();
            $sql = "INSERT INTO itemStockInventario (idDocumento, idArtigo, descricao, qtdDisponivel, qtd, preco) VALUES (?, ?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idDocumento, $idArtigo, $descricao, $qtdDisponivel, $qtd, $preco)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemItemStock(){
			$data = null;
			$sql = "SELECT * FROM itemStock";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryItemStock($idItemStock){
			$data = null;
			$sql = "SELECT * FROM itemStock WHERE idItemStock = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idItemStock]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryTipoTaxa($idTipoTaxa){
			$data = null;
			$sql = "SELECT * FROM tipotaxa WHERE idTipoTaxa = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTipoTaxa]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

        public function listaTipoTaxa(){
			$data = null;
			$sql = "SELECT * FROM tipotaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function editItemStock($idItemStock, $idDocumento, $idArtigo, $descricao, $qtdDisponivel, $qtd, $preco){
			$stmt = $this->connect();
			
            $sql = "UPDATE itemStock SET idDocumento = ?, idArtigo = ?, descricao = ?, qtdDisponivel = ?, qtd = ?, preco = ? WHERE idItemStock = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($idDocumento, $idArtigo, $descricao, $qtdDisponivel, $qtd, $preco, $idItemStock)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function deleteItemStock($idItemStock){
			$stmt = $this->connect();
            $sql = "DELETE FROM ItemStock WHERE idItemStock = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idItemStock)))){
				$query = null;
				exit();
			}
		}
    }