<?php

class ImpostoModel extends Database {

	protected function insertImposto($nome, $taxa, $codigoTaxa, $motivoIsencao, $descricaoDocumento){
		$stmt = $this->connect();
		$sql = "INSERT INTO imposto (nome, taxa, codigoTaxa, motivoIsencao, descricaoDocumento) VALUES (?, ?, ?, ?, ?)";
		$query = $stmt->prepare($sql);
		if(!($query->execute(array($nome, $taxa, $codigoTaxa, $motivoIsencao, $descricaoDocumento)))){
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

		protected function editImposto($idImposto, $nome, $taxa, $codigoTaxa, $motivoIsencao, $descricaoDocumento){
			$sql = "UPDATE imposto SET nome = ?, taxa = ?, codigoTaxa = ?, motivoIsencao = ?, descricaoDocumento = ? WHERE idImposto = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute(array($nome, $taxa, $codigoTaxa, $motivoIsencao, $descricaoDocumento, $idImposto))){
				$stmt = null;
				exit();
			}
			$stmt = null;
		}
		
		public function parentImposto(){
			$data = null;
			$sql = "SELECT * FROM imposto";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function readCodigoImposto(){
			$data = null;
			$sql = "SELECT COALESCE(MAX(idImposto), 0) + 1 AS contador FROM imposto";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function funcaoQueryImposto($idImposto){
			$data = null;
			$sql = "SELECT * FROM viewimposto WHERE idImposto = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idImposto]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function listagemImposto(){
			$data = null;
			$sql = "SELECT * FROM imposto";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function deleteImposto($idImposto){
			$sql = "DELETE FROM imposto WHERE idImposto = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute([$idImposto])){
				$stmt = null;
				exit();
			}
			$stmt = null;
		}

		protected function selectImposto(){
			$sql = "SELECT * FROM imposto";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<option name="idImposto" value="'.$row['idImposto'].'">' . $row['nome'] . '</option>';//'<option value='"$row['idImposto']"'>'"$row['nome']"'</option>';
				//echo $row['idUsuario'];
				//echo $row['nome'];
			}

		}

		protected function listaImposto(){
			$sql = "SELECT * FROM imposto";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<tr>
					<td>'.$row['idImposto'].'</td>
					<td>'.$row['nome'].'</td>
					<td>
						<a href="../includes/ImpostoUpdate.inc.php?id='.$row['idImposto'].'" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../includes/ImpostoDelete.inc.php?id='.$row['idImposto'].'"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
			}

		}

		protected function countImposto(){
			$sql = "SELECT COUNT(*) FROM imposto";
			$stmt = $this->connect()->query($sql);
			$results = $stmt->fetch();
			echo $results['COUNT(*)'];
		}
	}