<?php

class CodigoTaxaModel extends Database {

	protected function insertCodigoTaxa($nome, $nota){
		$stmt = $this->connect();
		$sql = "INSERT INTO codigoTaxa (nome, nota) VALUES (?, ?)";
		$query = $stmt->prepare($sql);
		if(!($query->execute(array($nome, $nota)))){
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

		protected function editCodigoTaxa($idCodigoTaxa, $nome, $nota){
			$sql = "UPDATE codigoTaxa SET nome = ?, nota = ? WHERE idCodigoTaxa = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute(array($nome, $nota, $idCodigoTaxa))){
				$stmt = null;
				exit();
			}
			$stmt = null;
		}
		
		public function parentCodigoTaxa(){
			$data = null;
			$sql = "SELECT * FROM codigoTaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function readCodigoCodigoTaxa(){
			$data = null;
			$sql = "SELECT COALESCE(MAX(idCodigoTaxa), 0) + 1 AS contador FROM codigoTaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryCodigoTaxa($idCodigoTaxa){
			$data = null;
			$sql = "SELECT * FROM codigoTaxa WHERE idCodigoTaxa = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idCodigoTaxa]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function listagemCodigoTaxa(){
			$data = null;
			$sql = "SELECT * FROM codigoTaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function deleteCodigoTaxa($idCodigoTaxa){
			$sql = "DELETE FROM codigoTaxa WHERE idCodigoTaxa = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute([$idCodigoTaxa])){
				$stmt = null;
				exit();
			}
			$stmt = null;
		}

		protected function funcaoReadCodigoTaxa(){
			$sql = "SELECT * FROM codigoTaxa";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<option name="idCodigoTaxa" value="'.$row['idCodigoTaxa'].'">' . $row['nome'] . '</option>';//'<option value='"$row['idCodigoTaxa']"'>'"$row['nome']"'</option>';
				//echo $row['idUsuario'];
				//echo $row['nome'];
			}

		}

		protected function listaCodigoTaxa(){
			$sql = "SELECT * FROM codigoTaxa";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<tr>
					<td>'.$row['idCodigoTaxa'].'</td>
					<td>'.$row['nome'].'</td>
					<td>
						<a href="../includes/CodigoTaxaUpdate.inc.php?id='.$row['idCodigoTaxa'].'" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../includes/CodigoTaxaDelete.inc.php?id='.$row['idCodigoTaxa'].'"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
			}

		}

		protected function countCodigoTaxa(){
			$sql = "SELECT COUNT(*) FROM codigoTaxa";
			$stmt = $this->connect()->query($sql);
			$results = $stmt->fetch();
			echo $results['COUNT(*)'];
		}

		public function autoIncrementCodigoTaxa()
		{
			$sql = "SELECT `AUTO_INCREMENT`
				FROM INFORMATION_SCHEMA.TABLES
				WHERE TABLE_SCHEMA = 'test1234'
				AND TABLE_NAME = 'codigoTaxa';";
			$stmt = $this->connect()->query($sql);
			$results = $stmt->fetch();
			return $results['AUTO_INCREMENT'];
		}
	}