<?php

class ArtigoModel extends Database
{

	protected function insertArtigo($idUsuario, $idFamilia, $idUnidadeMedida, $tipoArtigo, $nome, $nomeCurto, $codigoBarra, $unidadeVenda, $descontinuado, $controlaStock, $precoCustoSemImp, $precoCustoComImp)
	{
		$stmt = $this->connect();
		$sql = "INSERT INTO artigo (idUsuario, idFamilia, idUnidadeMedida, tipoArtigo, nome, nomeCurto, codigoBarra, unidadeVenda, descontinuado, controlaStock, precoCustoSemImp, precoCustoComImp) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
		$query = $stmt->prepare($sql);
		if (!($query->execute(array($idUsuario, $idFamilia, $idUnidadeMedida, $tipoArtigo, $nome, $nomeCurto, $codigoBarra, $unidadeVenda, $descontinuado, $controlaStock, $precoCustoSemImp, $precoCustoComImp)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function editArtigo($idArtigo, $idUsuario, $idFamilia, $idUnidadeMedida, $tipoArtigo, $nome, $nomeCurto, $codigoBarra, $unidadeVenda, $descontinuado, $controlaStock, $precoCustoSemImp, $precoCustoComImp)
	{
		$sql = "UPDATE artigo SET idUsuario = ?, idFamilia = ?, idUnidadeMedida = ?, tipoArtigo = ?, nome = ?, nomeCurto = ?, codigoBarra = ?, unidadeVenda = ?, descontinuado = ?, controlaStock = ?, precoCustoSemImp = ?, precoCustoComImp = ? WHERE idArtigo = ?";
		$stmt = $this->connect()->prepare($sql);
		if (!$stmt->execute(array($idUsuario, $idFamilia, $idUnidadeMedida, $tipoArtigo, $nome, $nomeCurto, $codigoBarra, $unidadeVenda, $descontinuado, $controlaStock, $precoCustoSemImp, $precoCustoComImp, $idArtigo))) {
			$stmt = null;
			exit();
		}
		$stmt = null;
	}

	public function parentArtigo()
	{
		$data = null;
		$sql = "SELECT * FROM artigo";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function readCodigoArtigo()
	{
		$data = null;
		$sql = "SELECT COALESCE(MAX(idArtigo), 0) + 1 AS contador FROM artigo";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryArtigo($idArtigo)
	{
		$data = null;
		$sql = "SELECT * FROM artigo WHERE idArtigo = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idArtigo]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function verifyItem($idArtigo)
	{
		$data = null;
		$sql = "SELECT * FROM artigo WHERE idArtigo = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idArtigo]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listagemArtigo($linhaPreco)
	{
		$data = null;
		$sql = "SELECT * FROM viewartigousuariofamilia";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$preco = $this->queryPrecoPredefinido($row["idArtigo"], $linhaPreco);
				$stock = $this->queryStockArtigo($row["idArtigo"]);
				if($preco != null){
					$row["precoComImposto"] = $preco[0]["comImposto"];
					$row["precoSemImposto"] = $preco[0]["semImposto"];
				} else {
					$row["precoComImposto"] = $preco;
					$row["precoSemImposto"] = $preco;
				}
				$row["stock"] = $stock[0]["qtdDisponivel"];
				$data[] = $row;
			}
		}
		return $data;
	}

	private function queryPrecoPredefinido($idArtigo, $linhaPreco)
	{
		$data = null;
		$sql = "SELECT * FROM precoArtigo WHERE idArtigo = ? AND indice = ";
		if($linhaPreco == 0){
			$sql .= "(SELECT valor FROM definicao WHERE idDefinicao = 2)";
		} else {
			$sql .= $linhaPreco;
		}
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idArtigo]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	private function queryStockArtigo($idArtigo)
	{
		$data = null;
		$sql = "SELECT * FROM artigoStock WHERE idArtigo = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idArtigo]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryListagemArtigo($idArtigo, $linhaPreco)
	{
		$data = null;
		$sql = "SELECT * FROM viewartigousuariofamilia WHERE idArtigo = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idArtigo]);
			while ($row = $stmt->fetch()) {
				$preco = $this->queryPrecoPredefinido($row["idArtigo"], $linhaPreco);
				$stock = $this->queryStockArtigo($row["idArtigo"]);
				if($preco != null){
					$row["precoComImposto"] = $preco[0]["comImposto"];
					$row["precoSemImposto"] = $preco[0]["semImposto"];
				} else {
					$row["precoComImposto"] = $preco;
					$row["precoSemImposto"] = $preco;
				}
				$row["stock"] = $stock[0]["qtdDisponivel"];
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listagemTodosArtigoStock()
	{
		$data = null;
		$sql = "SELECT * FROM viewtudoartigo vta WHERE vta.precoArtigoIndice = (SELECT valor FROM definicao WHERE idDefinicao = 2)";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listagemArtigoStock($idArtigo)
	{
		$data = null;
		$sql = "SELECT * FROM viewtudoartigo vta INNER JOIN artigostock ast ON (vta.idArtigo = ast.idArtigo) WHERE vta.precoArtigoIndice = (SELECT valor FROM definicao WHERE idDefinicao = 2) AND vta.idArtigo = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idArtigo]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function deleteArtigo($idArtigo)
	{	
		$img = $this->queryArtigo($idArtigo);
		$nameImg = "../../images/artigo/" . $img[0]["imagem"];
		if($img[0]["imagem"] != null){
			unlink($nameImg);
		}
		$stmt = $this->connect();
		$sql = "DELETE FROM artigo WHERE idArtigo = ?";
		$query = $stmt->prepare($sql);
		if (!$query->execute([$idArtigo])) {
			$query = null;
			exit();
		}
	}

	protected function selectArtigo()
	{
		$sql = "SELECT * FROM artigo";
		$stmt = $this->connect()->query($sql);
		while ($row = $stmt->fetch()) {

			echo '<option name="idArtigo" value="' . $row['idArtigo'] . '">' . $row['nome'] . '</option>'; //'<option value='"$row['idArtigo']"'>'"$row['nome']"'</option>';
			//echo $row['idUsuario'];
			//echo $row['nome'];
		}
	}

	protected function listaArtigo()
	{
		$sql = "SELECT * FROM artigo";
		$stmt = $this->connect()->query($sql);
		while ($row = $stmt->fetch()) {

			echo '<tr>
					<td>' . $row['idArtigo'] . '</td>
					<td>' . $row['nome'] . '</td>
					<td>
						<a href="../includes/ArtigoUpdate.inc.php?id=' . $row['idArtigo'] . '" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../includes/ArtigoDelete.inc.php?id=' . $row['idArtigo'] . '"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
		}
	}

	public function autoIncrementArtigo()
	{
		$sql = "SELECT `AUTO_INCREMENT` AS contador
			FROM INFORMATION_SCHEMA.TABLES
			WHERE TABLE_SCHEMA = 'test1234'
			AND TABLE_NAME = 'artigo';";
		$stmt = $this->connect()->query($sql);
		$results = $stmt->fetch();
		return $results['contador'];
	}

	protected function countArtigo()
	{
		$sql = "SELECT COUNT(*) FROM artigo";
		$stmt = $this->connect()->query($sql);
		$results = $stmt->fetch();
		echo $results['COUNT(*)'];
	}
}
